<?php
// database/seeders/KegiatanSeeder.php

namespace Database\Seeders;

use App\Models\Kegiatan;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class KegiatanSeeder extends Seeder
{
    public function run(): void
    {
        $kegiatans = [
            [
                'nama_pelatihan' => 'Pelatihan Manajemen Agribisnis 7',
                'kode_pelatihan' => 'PMA-7',
                'tanggal_mulai' => '2025-10-06',
                'tanggal_selesai' => '2025-10-09',
                'kuota' => 30,
                'status' => 'active',
                'deskripsi' => 'Pelatihan Manajemen Agribisnis untuk pengelolaan usaha tani yang efektif dan efisien',
            ],
            [
                'nama_pelatihan' => 'Pelatihan Pascapanen 7',
                'kode_pelatihan' => 'PP-7',
                'tanggal_mulai' => '2025-10-06',
                'tanggal_selesai' => '2025-10-09',
                'kuota' => 30,
                'status' => 'active',
                'deskripsi' => 'Pelatihan teknik pascapanen untuk meningkatkan kualitas hasil pertanian',
            ],
            [
                'nama_pelatihan' => 'Pelatihan Pascapanen 8',
                'kode_pelatihan' => 'PP-8',
                'tanggal_mulai' => '2025-10-06',
                'tanggal_selesai' => '2025-10-09',
                'kuota' => 30,
                'status' => 'active',
                'deskripsi' => 'Pelatihan teknik pascapanen lanjutan',
            ],
            [
                'nama_pelatihan' => 'Pelatihan Pascapanen 9',
                'kode_pelatihan' => 'PP-9',
                'tanggal_mulai' => '2025-10-14',
                'tanggal_selesai' => '2025-10-17',
                'kuota' => 30,
                'status' => 'active',
                'deskripsi' => 'Pelatihan pascapanen spesialis komoditas tertentu',
            ],
            [
                'nama_pelatihan' => 'Pelatihan Pascapanen 10',
                'kode_pelatihan' => 'PP-10',
                'tanggal_mulai' => '2025-10-14',
                'tanggal_selesai' => '2025-10-17',
                'kuota' => 30,
                'status' => 'active',
                'deskripsi' => 'Pelatihan pascapanen tingkat mahir',
            ],
            [
                'nama_pelatihan' => 'Pelatihan Mekanisasi, Modernisasi dan Digitalisasi komoditas tembakau 1',
                'kode_pelatihan' => 'MMD-T-1',
                'tanggal_mulai' => '2025-11-20',
                'tanggal_selesai' => '2025-11-23',
                'kuota' => 30,
                'status' => 'active',
                'deskripsi' => 'Pelatihan mekanisasi dan digitalisasi untuk komoditas tembakau',
            ],
            [
                'nama_pelatihan' => 'Pelatihan Mekanisasi, Modernisasi dan Digitalisasi komoditas tembakau 2',
                'kode_pelatihan' => 'MMD-T-2',
                'tanggal_mulai' => '2025-11-20',
                'tanggal_selesai' => '2025-11-23',
                'kuota' => 30,
                'status' => 'active',
                'deskripsi' => 'Pelatihan mekanisasi dan digitalisasi lanjutan untuk komoditas tembakau',
            ],
            [
                'nama_pelatihan' => 'Pelatihan Mekanisasi, Modernisasi dan Digitalisasi komoditas tembakau 9',
                'kode_pelatihan' => 'MMD-T-9',
                'tanggal_mulai' => '2025-11-03',
                'tanggal_selesai' => '2025-11-06',
                'kuota' => 30,
                'status' => 'active',
                'deskripsi' => 'Pelatihan mekanisasi dan digitalisasi tingkat ahli untuk komoditas tembakau',
            ],
        ];

        foreach ($kegiatans as $kegiatan) {
            Kegiatan::create($kegiatan);
        }
    }
}