<div>
    <div class="max-w-6xl mx-auto">
        <!-- Header Information -->
        <div class="text-center mb-8">
            <h1 class="text-3xl font-bold text-gray-900 mb-2">
                PENDAFTARAN KEGIATAN PELATIHAN
            </h1>
            <h2 class="text-xl font-semibold text-gray-700 mb-4">
                BALAI PELATIHAN PERTANIAN (BAPELTAN) JAWA TENGAH
            </h2>
            <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4 mb-6">
                <p class="text-yellow-800 text-sm">
                    <i class="fas fa-exclamation-triangle mr-2"></i>
                    <strong>Pendaftaran ditutup 30 September 2025 Pukul 00.00 WIB</strong>
                </p>
            </div>
        </div>

        <!-- Alert Messages -->
        <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
            <div class="alert-success">
                <div class="flex items-center">
                    <i class="fas fa-check-circle mr-3 text-green-600"></i>
                    <span><?php echo e(session('success')); ?></span>
                </div>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <?php if(session()->has('error')): ?>
            <div class="alert-error">
                <div class="flex items-center">
                    <i class="fas fa-exclamation-circle mr-3 text-red-600"></i>
                    <span><?php echo e(session('error')); ?></span>
                </div>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <!-- Registration Form -->
        <div class="form-section">
            <h2 class="form-title">
                <i class="fas fa-user-plus mr-2"></i>
                FORM PENDAFTARAN PESERTA PELATIHAN
            </h2>
            <div class="form-content">
                <form wire:submit="create" class="space-y-6">
                    <?php echo e($this->form); ?>


                    <!-- Syarat dan Ketentuan -->
                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mt-6">
                        <h3 class="font-semibold text-blue-900 mb-3 flex items-center">
                            <i class="fas fa-clipboard-list mr-2"></i>
                            Syarat dan Ketentuan:
                        </h3>
                        <ul class="text-sm text-blue-800 list-disc list-inside space-y-1">
                            <li>Sehat jasmani dan rohani</li>
                            <li>Usia Maksimal 50 Tahun dan bisa mengoperasionalkan Handphone Android</li>
                            <li>Bagi Wanita tidak dalam keadaan Hamil/Menyusui</li>
                            <li>Petani milenial/pemuda tani/petani tergabung dalam kelompok tani, ataupun Penyuluh
                                Pendamping</li>
                            <li>Belum pernah mengikuti pelatihan sejenis</li>
                            <li>Bersedia mengikuti seluruh rangkaian kegiatan pelatihan (wajib)</li>
                            <li>Berpakaian rapi dan sopan (mengenakan sepatu) selama mengikuti kegiatan pelatihan</li>
                        </ul>
                    </div>

                    <!-- Submit Button -->
                    <div class="text-center pt-6">
                        <button type="submit"
                            class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-8 rounded-lg transition duration-200 flex items-center justify-center mx-auto">
                            <i class="fas fa-paper-plane mr-2"></i>
                            KIRIM PENDAFTARAN
                        </button>
                        <p class="text-sm text-gray-600 mt-2">
                            Dengan mengirim formulir ini, saya menyetujui semua syarat dan ketentuan yang berlaku
                        </p>
                    </div>
                </form>
            </div>
        </div>

        <!-- Informasi Fasilitas -->
        <div class="form-section">
            <h2 class="form-title">
                <i class="fas fa-gift mr-2"></i>
                FASILITAS PESERTA
            </h2>
            <div class="form-content">
                <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-4">
                    <div class="bg-green-50 p-4 rounded-lg border border-green-200">
                        <div class="flex items-center mb-2">
                            <i class="fas fa-utensils text-green-600 mr-3"></i>
                            <h4 class="font-semibold text-green-800">Konsumsi</h4>
                        </div>
                        <p class="text-sm text-green-700">3x Makan + 2x Snack per hari</p>
                    </div>

                    <div class="bg-purple-50 p-4 rounded-lg border border-purple-200">
                        <div class="flex items-center mb-2">
                            <i class="fas fa-bed text-purple-600 mr-3"></i>
                            <h4 class="font-semibold text-purple-800">Akomodasi</h4>
                        </div>
                        <p class="text-sm text-purple-700">Asrama 4 hari 3 malam</p>
                    </div>

                    <div class="bg-yellow-50 p-4 rounded-lg border border-yellow-200">
                        <div class="flex items-center mb-2">
                            <i class="fas fa-money-bill-wave text-yellow-600 mr-3"></i>
                            <h4 class="font-semibold text-yellow-800">Transport</h4>
                        </div>
                        <p class="text-sm text-yellow-700">Uang harian Rp 50.000/hari</p>
                    </div>

                    <div class="bg-blue-50 p-4 rounded-lg border border-blue-200">
                        <div class="flex items-center mb-2">
                            <i class="fas fa-certificate text-blue-600 mr-3"></i>
                            <h4 class="font-semibold text-blue-800">Sertifikat</h4>
                        </div>
                        <p class="text-sm text-blue-700">Sertifikat pelatihan resmi</p>
                    </div>

                    <div class="bg-red-50 p-4 rounded-lg border border-red-200">
                        <div class="flex items-center mb-2">
                            <i class="fas fa-briefcase text-red-600 mr-3"></i>
                            <h4 class="font-semibold text-red-800">Seminar Kit</h4>
                        </div>
                        <p class="text-sm text-red-700">Pouch bag, bolpoin, bloknote</p>
                    </div>

                    <div class="bg-indigo-50 p-4 rounded-lg border border-indigo-200">
                        <div class="flex items-center mb-2">
                            <i class="fas fa-graduation-cap text-indigo-600 mr-3"></i>
                            <h4 class="font-semibold text-indigo-800">Ilmu Terapan</h4>
                        </div>
                        <p class="text-sm text-indigo-700">Pengetahuan & ketrampilan praktis</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Informasi Lokasi -->
        <div class="form-section">
            <h2 class="form-title">
                <i class="fas fa-map-marker-alt mr-2"></i>
                LOKASI PELATIHAN
            </h2>
            <div class="form-content">
                <div class="bg-gray-50 p-4 rounded-lg">
                    <p class="text-gray-700 mb-4">
                        <i class="fas fa-info-circle mr-2 text-blue-600"></i>
                        <strong>Peserta diharapkan sudah hadir dan registrasi ulang di BAPELTAN Jateng
                            (Soropadan)</strong>
                    </p>
                    <p class="text-gray-600 flex items-start">
                        <i class="fas fa-map-pin mr-3 text-red-500 mt-1"></i>
                        Jl. Raya Magelang-Semarang Km.12,8 Soropadan Pringsurat<br>
                        Kab. Temanggung, Jawa Tengah
                    </p>
                    <p class="text-gray-600 mt-2 flex items-center">
                        <i class="fas fa-clock mr-3 text-green-500"></i>
                        Hari pertama, pukul 10.00 WIB
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\xampp\htdocs\bapeltan-registration\resources\views/livewire/public-registration-form.blade.php ENDPATH**/ ?>